## RabbitMQ 3.8.11

RabbitMQ `3.8.11` is a maintenance release that contains bug fixes.

This release [**no longer supports** Erlang 21.3](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 22](https://www.rabbitmq.com/which-erlang.html) or
[Erlang 23](http://blog.erlang.org/OTP-23-Highlights/).

Erlang 21.3 [**is no longer supported**](https://groups.google.com/forum/#!topic/rabbitmq-users/v3K5nZNsfwM).
`22.3` or `23.2` releases are recommended.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `22.3.x`.


## Upgrade and Compatibility Notes

### Upgrade Doc Guides and Change Log

See [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0) upgrade and
compatibility notes first if upgrading from an earlier release series (e.g. `3.7.x`).

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Upgrading to Erlang 22.x or Later Versions

When upgrading to this release from `3.7.15` or an older version, extra care has to be taken.

Because older RabbitMQ CLI tools can be incompatible with Erlang 22+ releases,
RabbitMQ **must be upgraded at the same time as Erlang**.

Alternatively the node can be upgraded to `3.7.18` on Erlang 21.3 first,
then Erlang 22.x or 23.x, then RabbitMQ to the most recent 3.8.x release.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Bug Fixes

 * Quorum queues that had active consumers during a rolling cluster upgrade could run into an exception and restart loop.

   This issue is specific to [RabbitMQ `3.8.10`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.10).

   GitHub issue: [rabbitmq/rabbitmq-server#2728](https://github.com/rabbitmq/rabbitmq-server/pull/2728)

 * Nodes that had `reverse_dns_lookup` set to `true` could not accept client connections.

   This issue is specific to [RabbitMQ `3.8.10`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.10).

   GitHub issue: [rabbitmq/rabbitmq-server#2730](https://github.com/rabbitmq/rabbitmq-server/issues/2730)


## Dependency Upgrades

No dependency changes.


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker, not the plugins or the client libraries.
Please download the archive named `rabbitmq-server-3.8.11.tar.xz`.
