% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-identity.r, R/zxx.r
\name{scale_identity}
\alias{scale_colour_identity}
\alias{scale_fill_identity}
\alias{scale_shape_identity}
\alias{scale_linetype_identity}
\alias{scale_linewidth_identity}
\alias{scale_alpha_identity}
\alias{scale_size_identity}
\alias{scale_discrete_identity}
\alias{scale_continuous_identity}
\alias{scale_color_identity}
\title{Use values without scaling}
\usage{
scale_colour_identity(..., guide = "none", aesthetics = "colour")

scale_fill_identity(..., guide = "none", aesthetics = "fill")

scale_shape_identity(..., guide = "none")

scale_linetype_identity(..., guide = "none")

scale_linewidth_identity(..., guide = "none")

scale_alpha_identity(..., guide = "none")

scale_size_identity(..., guide = "none")

scale_discrete_identity(aesthetics, ..., guide = "none")

scale_continuous_identity(aesthetics, ..., guide = "none")
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[=discrete_scale]{discrete_scale()}} or
\code{\link[=continuous_scale]{continuous_scale()}}}

\item{guide}{Guide to use for this scale. Defaults to \code{"none"}.}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}
}
\description{
Use this set of scales when your data has already been scaled, i.e. it
already represents aesthetic values that ggplot2 can handle directly.
These scales will not produce a legend unless you also supply the \code{breaks},
\code{labels}, and type of \code{guide} you want.
}
\details{
The functions \code{scale_colour_identity()}, \code{scale_fill_identity()}, \code{scale_size_identity()},
etc. work on the aesthetics specified in the scale name: \code{colour}, \code{fill}, \code{size},
etc. However, the functions \code{scale_colour_identity()} and \code{scale_fill_identity()} also
have an optional \code{aesthetics} argument that can be used to define both \code{colour} and
\code{fill} aesthetic mappings via a single function call. The functions
\code{scale_discrete_identity()} and \code{scale_continuous_identity()} are generic scales that
can work with any aesthetic or set of aesthetics provided via the \code{aesthetics}
argument.
}
\examples{
ggplot(luv_colours, aes(u, v)) +
  geom_point(aes(colour = col), size = 3) +
  scale_color_identity() +
  coord_fixed()

df <- data.frame(
  x = 1:4,
  y = 1:4,
  colour = c("red", "green", "blue", "yellow")
)
ggplot(df, aes(x, y)) + geom_tile(aes(fill = colour))
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity()

# To get a legend guide, specify guide = "legend"
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity(guide = "legend")
# But you'll typically also need to supply breaks and labels:
ggplot(df, aes(x, y)) +
  geom_tile(aes(fill = colour)) +
  scale_fill_identity("trt", labels = letters[1:4], breaks = df$colour,
  guide = "legend")

# cyl scaled to appropriate size
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(size = cyl))

# cyl used as point size
ggplot(mtcars, aes(mpg, wt)) +
  geom_point(aes(size = cyl)) +
  scale_size_identity()
}
