% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeToGene.R
\docType{methods}
\name{summarizeToGene,SummarizedExperiment-method}
\alias{summarizeToGene,SummarizedExperiment-method}
\title{Summarize estimated quantitites to gene-level}
\usage{
\S4method{summarizeToGene}{SummarizedExperiment}(
  object,
  assignRanges = c("range", "abundant"),
  varReduce = FALSE,
  ...
)
}
\arguments{
\item{object}{a SummarizedExperiment produced by \code{tximeta}}

\item{assignRanges}{\code{"range"} or \code{"abundant"}, this argument
controls the way that the \code{rowRanges} of the output object are assigned
(note that this argument does not affect data aggregation at all).
The default is to just output the entire \code{range} of the gene,
i.e. the leftmost basepair to the rightmost basepair across all isoforms.
Alternatively, for expressed genes, one can obtain the start and end
of the most \code{abundant} isoform (averaging over all samples).
Non-expressed genes will have \code{range}-based positions.
For \code{abundant}, for expressed genes,
the name of the range-assigned \code{isoform}, \code{max_prop}
(maximum isoform proportion), and \code{iso_prop} (numeric values for
isoform proportions) are also returned in \code{mcols}}

\item{varReduce}{whether to reduce per-sample inferential replicates
information into a matrix of sample variances \code{variance} (default FALSE)}

\item{...}{arguments passed to \code{tximport}}
}
\value{
a SummarizedExperiment with summarized quantifications
and transcript IDs as a CharacterList in the \code{mcols}
}
\description{
Summarizes abundances, counts, lengths, (and inferential
replicates or variance) from transcript- to gene-level.
Transcript IDs are stored as a CharacterList in the \code{mcols}
of the output object.
This function operates on SummarizedExperiment objects, and
will automatically access the relevant TxDb (by either finding it
in the BiocFileCache or by building it from an ftp location).
This function uses the tximport package to perform summarization,
where a method is defined that works on simple lists.
}
\examples{

example(tximeta)
gse <- summarizeToGene(se)

}
