% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSegmentationFile.R
\name{readSegmentationFile}
\alias{readSegmentationFile}
\title{Read file containing segmentations}
\usage{
readSegmentationFile(
  seg.file,
  sampleid,
  model.homozygous = FALSE,
  format,
  zero = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seg.file}{File with segmentation}

\item{sampleid}{Sampleid, for segmentation files containing multiple samples}

\item{model.homozygous}{Unless \code{TRUE}, checks for very small log2-ratios
that cannot happen in samples with normal contamination}

\item{format}{File format. If missing, derived from the file
extension. Currently DNAcopy, and GATK4
(ModelSegments) format supported. CNVkit uses DNAcopy format.}

\item{zero}{Start position is 0-based. Default is \code{FALSE}.}

\item{verbose}{Verbose output.}
}
\value{
A \code{data.frame}.
}
\description{
Read segmentation files produced by DNAcopy, CNVkit or GATK4.
}
\examples{

seg.file <- system.file("extdata", "example_seg.txt",
    package = "PureCN")
seg <- readSegmentationFile(seg.file, "Sample1")

}
\author{
Markus Riester
}
