% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genePlots.R
\name{degPlotWide}
\alias{degPlotWide}
\title{Plot selected genes on a wide format}
\usage{
degPlotWide(counts, genes, group, metadata = NULL, batch = NULL)
}
\arguments{
\item{counts}{\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} object or expression matrix}

\item{genes}{character genes to plot.}

\item{group}{character, colname in colData to color points and add different
lines for each level}

\item{metadata}{data.frame, information for each sample. Not needed if
\link[DESeq2:DESeqDataSet]{DESeq2::DESeqDataSet} given as counts.}

\item{batch}{character, colname in colData to shape points, normally used by
batch effect visualization}
}
\value{
ggplot showing the expresison of the genes on the x
axis
}
\description{
Plot selected genes on a wide format
}
\examples{
data(humanGender)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(assays(humanGender)[[1]][1:1000, idx],
  colData(humanGender)[idx,], design=~group)
dse <- DESeq(dse)
degPlotWide(dse, rownames(dse)[1:10], group = "group")
}
