% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnoyParam-class.R
\docType{class}
\name{AnnoyParam}
\alias{AnnoyParam}
\alias{AnnoyParam-class}
\alias{show,AnnoyParam-method}
\alias{AnnoyParam_ntrees}
\alias{AnnoyParam_directory}
\alias{AnnoyParam_search_mult}
\alias{[[,AnnoyParam-method}
\alias{[[<-,AnnoyParam-method}
\title{The AnnoyParam class}
\usage{
AnnoyParam(
  ntrees = 50,
  directory = tempdir(),
  search.mult = ntrees,
  distance = "Euclidean"
)
}
\arguments{
\item{ntrees}{Integer scalar, number of trees to use for index generation.}

\item{directory}{String containing the path to the directory in which to save the index.}

\item{search.mult}{Numeric scalar, multiplier for the number of points to search.}

\item{distance}{String, the distance metric to use.}
}
\value{
An instance of the AnnoyParam class.
}
\description{
A class to hold parameters for the Annoy algorithm for approximate nearest neighbor identification.
}
\details{
The AnnoyParam class holds all parameters associated with running the Annoy algorithm.
Most of these parameters are used to build the index - see \code{\link{buildAnnoy}} for details.

Users can get or set values with the usual \code{[[} syntax.
All parameters listed in the constructor can be manipulated in this manner.
}
\examples{
(out <- AnnoyParam())
out[['ntrees']]

out[['ntrees']] <- 20L
out

}
\seealso{
\code{\link{buildAnnoy}}, for the index construction.

\code{\link{findAnnoy}} and related functions, for the actual search. 

\linkS4class{BiocNeighborParam}, for the parent class and its available methods.
}
\author{
Aaron Lun
}
