# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class SinkValidateList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, sid):
        """
        Initialize the SinkValidateList

        :param Version version: Version that contains the resource
        :param sid: A string that uniquely identifies this Sink.

        :returns: twilio.rest.events.v1.sink.sink_validate.SinkValidateList
        :rtype: twilio.rest.events.v1.sink.sink_validate.SinkValidateList
        """
        super(SinkValidateList, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Sinks/{sid}/Validate'.format(**self._solution)

    def create(self, test_id):
        """
        Create the SinkValidateInstance

        :param unicode test_id: A string that uniquely identifies the test event for a Sink being validated.

        :returns: The created SinkValidateInstance
        :rtype: twilio.rest.events.v1.sink.sink_validate.SinkValidateInstance
        """
        data = values.of({'TestId': test_id, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return SinkValidateInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkValidateList>'


class SinkValidatePage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the SinkValidatePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param sid: A string that uniquely identifies this Sink.

        :returns: twilio.rest.events.v1.sink.sink_validate.SinkValidatePage
        :rtype: twilio.rest.events.v1.sink.sink_validate.SinkValidatePage
        """
        super(SinkValidatePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of SinkValidateInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.events.v1.sink.sink_validate.SinkValidateInstance
        :rtype: twilio.rest.events.v1.sink.sink_validate.SinkValidateInstance
        """
        return SinkValidateInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkValidatePage>'


class SinkValidateInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, payload, sid):
        """
        Initialize the SinkValidateInstance

        :returns: twilio.rest.events.v1.sink.sink_validate.SinkValidateInstance
        :rtype: twilio.rest.events.v1.sink.sink_validate.SinkValidateInstance
        """
        super(SinkValidateInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'result': payload.get('result'), }

        # Context
        self._context = None
        self._solution = {'sid': sid, }

    @property
    def result(self):
        """
        :returns: Feedback indicating whether the given Sink was validated.
        :rtype: unicode
        """
        return self._properties['result']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Events.V1.SinkValidateInstance>'
