#!/bin/bash

# Run this from project root directory
go mod vendor

# Download only the dependencies that are not yet available in Debian
MODULES=(
  "github.com/micro-editor/terminal"
  "github.com/micro-editor/tcell/v2"
  "github.com/micro-editor/json5"
)

# Loop through each module
for MODULE in "${MODULES[@]}"
do
  rm -rf debian/vendor/"$MODULE"
  mkdir -p debian/vendor/"$MODULE"
  cp --archive --update --verbose vendor/"$MODULE"/* debian/vendor/"$MODULE"/
  rm -rf vendor/"$MODULE"
done
