/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (c) 2012-2016, The Linux Foundation. All rights reserved.
 * Copyright (C) 2017 Linaro Ltd.
 */
#ifndef __VENUS_HFI_VENUS_IO_H__
#define __VENUS_HFI_VENUS_IO_H__

#define VBIF_BASE				0x80000

#define VBIF_AXI_HALT_CTRL0			0x208
#define VBIF_AXI_HALT_CTRL1			0x20c

#define VBIF_AXI_HALT_CTRL0_HALT_REQ		BIT(0)
#define VBIF_AXI_HALT_CTRL1_HALT_ACK		BIT(0)
#define VBIF_AXI_HALT_ACK_TIMEOUT_US		500000

#define CPU_BASE				0xc0000

#define CPU_CS_BASE				(CPU_BASE + 0x12000)
#define CPU_IC_BASE				(CPU_BASE + 0x1f000)
#define CPU_BASE_V6				0xa0000
#define CPU_CS_BASE_V6				CPU_BASE_V6
#define CPU_IC_BASE_V6				(CPU_BASE_V6 + 0x138)

#define CPU_CS_A2HSOFTINTCLR			0x1c

#define VIDC_CTRL_INIT				0x48
#define VIDC_CTRL_INIT_RESERVED_BITS31_1_MASK	0xfffffffe
#define VIDC_CTRL_INIT_RESERVED_BITS31_1_SHIFT	1
#define VIDC_CTRL_INIT_CTRL_MASK		0x1
#define VIDC_CTRL_INIT_CTRL_SHIFT		0

/* HFI control status */
#define CPU_CS_SCIACMDARG0			0x4c
#define CPU_CS_SCIACMDARG0_MASK			0xff
#define CPU_CS_SCIACMDARG0_SHIFT		0x0
#define CPU_CS_SCIACMDARG0_ERROR_STATUS_MASK	0xfe
#define CPU_CS_SCIACMDARG0_ERROR_STATUS_SHIFT	0x1
#define CPU_CS_SCIACMDARG0_INIT_STATUS_MASK	0x1
#define CPU_CS_SCIACMDARG0_INIT_STATUS_SHIFT	0x0
#define CPU_CS_SCIACMDARG0_PC_READY		BIT(8)
#define CPU_CS_SCIACMDARG0_INIT_IDLE_MSG_MASK	BIT(30)

/* HFI queue table info */
#define CPU_CS_SCIACMDARG1			0x50

/* HFI queue table address */
#define CPU_CS_SCIACMDARG2			0x54

/* Venus cpu */
#define CPU_CS_SCIACMDARG3			0x58

#define SFR_ADDR				0x5c
#define MMAP_ADDR				0x60
#define UC_REGION_ADDR				0x64
#define UC_REGION_SIZE				0x68

#define CPU_CS_H2XSOFTINTEN_V6			0x148

#define CPU_CS_X2RPMH_V6			0x168
#define CPU_CS_X2RPMH_MASK0_BMSK_V6		0x1
#define CPU_CS_X2RPMH_MASK0_SHFT_V6		0x0
#define CPU_CS_X2RPMH_MASK1_BMSK_V6		0x2
#define CPU_CS_X2RPMH_MASK1_SHFT_V6		0x1
#define CPU_CS_X2RPMH_SWOVERRIDE_BMSK_V6	0x4
#define CPU_CS_X2RPMH_SWOVERRIDE_SHFT_V6	0x3

/* Relative to CPU_IC_BASE */
#define CPU_IC_SOFTINT				0x18
#define CPU_IC_SOFTINT_V6			0x150
#define CPU_IC_SOFTINT_H2A_MASK			0x8000
#define CPU_IC_SOFTINT_H2A_SHIFT		0xf
#define CPU_IC_SOFTINT_H2A_SHIFT_V6		0x0

/* Venus wrapper */
#define WRAPPER_BASE_V6				0x000b0000
#define WRAPPER_BASE				0x000e0000

#define WRAPPER_HW_VERSION			0x00
#define WRAPPER_HW_VERSION_MAJOR_VERSION_MASK	0x78000000
#define WRAPPER_HW_VERSION_MAJOR_VERSION_SHIFT	28
#define WRAPPER_HW_VERSION_MINOR_VERSION_MASK	0xfff0000
#define WRAPPER_HW_VERSION_MINOR_VERSION_SHIFT	16
#define WRAPPER_HW_VERSION_STEP_VERSION_MASK	0xffff

#define WRAPPER_CLOCK_CONFIG			0x04

#define WRAPPER_INTR_STATUS			0x0c
#define WRAPPER_INTR_STATUS_A2HWD_MASK		0x10
#define WRAPPER_INTR_STATUS_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_STATUS_A2H_MASK		0x4
#define WRAPPER_INTR_STATUS_A2H_SHIFT		0x2

#define WRAPPER_INTR_MASK			0x10
#define WRAPPER_INTR_MASK_A2HWD_BASK		0x10
#define WRAPPER_INTR_MASK_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_MASK_A2HVCODEC_MASK	0x8
#define WRAPPER_INTR_MASK_A2HVCODEC_SHIFT	0x3
#define WRAPPER_INTR_MASK_A2HCPU_MASK		0x4
#define WRAPPER_INTR_MASK_A2HCPU_SHIFT		0x2

#define WRAPPER_INTR_STATUS_A2HWD_MASK_V6	0x8
#define WRAPPER_INTR_MASK_A2HWD_BASK_V6		0x8

#define WRAPPER_INTR_CLEAR			0x14
#define WRAPPER_INTR_CLEAR_A2HWD_MASK		0x10
#define WRAPPER_INTR_CLEAR_A2HWD_SHIFT		0x4
#define WRAPPER_INTR_CLEAR_A2H_MASK		0x4
#define WRAPPER_INTR_CLEAR_A2H_SHIFT		0x2

#define WRAPPER_POWER_STATUS			0x44
#define WRAPPER_VDEC_VCODEC_POWER_CONTROL	0x48
#define WRAPPER_VENC_VCODEC_POWER_CONTROL	0x4c
#define WRAPPER_DEBUG_BRIDGE_LPI_CONTROL_V6	0x54
#define WRAPPER_DEBUG_BRIDGE_LPI_STATUS_V6	0x58
#define WRAPPER_VDEC_VENC_AHB_BRIDGE_SYNC_RESET	0x64

#define WRAPPER_CPU_CLOCK_CONFIG		0x2000
#define WRAPPER_CPU_AXI_HALT			0x2008
#define WRAPPER_CPU_AXI_HALT_HALT		BIT(16)
#define WRAPPER_CPU_AXI_HALT_STATUS		0x200c
#define WRAPPER_CPU_AXI_HALT_STATUS_IDLE	BIT(24)

#define WRAPPER_CPU_CGC_DIS			0x2010
#define WRAPPER_CPU_STATUS			0x2014
#define WRAPPER_CPU_STATUS_WFI			BIT(0)
#define WRAPPER_SW_RESET			0x3000
#define WRAPPER_CPA_START_ADDR			0x1020
#define WRAPPER_CPA_END_ADDR			0x1024
#define WRAPPER_FW_START_ADDR			0x1028
#define WRAPPER_FW_END_ADDR			0x102C
#define WRAPPER_NONPIX_START_ADDR		0x1030
#define WRAPPER_NONPIX_END_ADDR			0x1034
#define WRAPPER_A9SS_SW_RESET			0x3000
#define WRAPPER_A9SS_SW_RESET_BIT		BIT(4)

/* Venus 4xx */
#define WRAPPER_VCODEC0_MMCC_POWER_STATUS	0x90
#define WRAPPER_VCODEC0_MMCC_POWER_CONTROL	0x94

#define WRAPPER_VCODEC1_MMCC_POWER_STATUS	0x110
#define WRAPPER_VCODEC1_MMCC_POWER_CONTROL	0x114

/* Venus 6xx */
#define WRAPPER_CORE_POWER_STATUS_V6		0x80
#define WRAPPER_CORE_POWER_CONTROL_V6		0x84

/* Wrapper TZ 6xx */
#define WRAPPER_TZ_BASE_V6			0x000c0000
#define WRAPPER_TZ_CPU_STATUS_V6		0x10
#define WRAPPER_TZ_XTSS_SW_RESET		0x1000
#define WRAPPER_XTSS_SW_RESET_BIT		BIT(0)

/* Venus AON */
#define AON_BASE_V6				0x000e0000
#define AON_WRAPPER_MVP_NOC_LPI_CONTROL		0x00
#define AON_WRAPPER_MVP_NOC_LPI_STATUS		0x04

#endif
