//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/migrate/armmigrate"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// ServerCollectorsServer is a fake server for instances of the armmigrate.ServerCollectorsClient type.
type ServerCollectorsServer struct {
	// Create is the fake for method ServerCollectorsClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *armmigrate.ServerCollectorsClientCreateOptions) (resp azfake.Responder[armmigrate.ServerCollectorsClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method ServerCollectorsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *armmigrate.ServerCollectorsClientDeleteOptions) (resp azfake.Responder[armmigrate.ServerCollectorsClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerCollectorsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, projectName string, serverCollectorName string, options *armmigrate.ServerCollectorsClientGetOptions) (resp azfake.Responder[armmigrate.ServerCollectorsClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByProjectPager is the fake for method ServerCollectorsClient.NewListByProjectPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByProjectPager func(resourceGroupName string, projectName string, options *armmigrate.ServerCollectorsClientListByProjectOptions) (resp azfake.PagerResponder[armmigrate.ServerCollectorsClientListByProjectResponse])
}

// NewServerCollectorsServerTransport creates a new instance of ServerCollectorsServerTransport with the provided implementation.
// The returned ServerCollectorsServerTransport instance is connected to an instance of armmigrate.ServerCollectorsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerCollectorsServerTransport(srv *ServerCollectorsServer) *ServerCollectorsServerTransport {
	return &ServerCollectorsServerTransport{
		srv:                   srv,
		newListByProjectPager: newTracker[azfake.PagerResponder[armmigrate.ServerCollectorsClientListByProjectResponse]](),
	}
}

// ServerCollectorsServerTransport connects instances of armmigrate.ServerCollectorsClient to instances of ServerCollectorsServer.
// Don't use this type directly, use NewServerCollectorsServerTransport instead.
type ServerCollectorsServerTransport struct {
	srv                   *ServerCollectorsServer
	newListByProjectPager *tracker[azfake.PagerResponder[armmigrate.ServerCollectorsClientListByProjectResponse]]
}

// Do implements the policy.Transporter interface for ServerCollectorsServerTransport.
func (s *ServerCollectorsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerCollectorsClient.Create":
		resp, err = s.dispatchCreate(req)
	case "ServerCollectorsClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "ServerCollectorsClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerCollectorsClient.NewListByProjectPager":
		resp, err = s.dispatchNewListByProjectPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerCollectorsServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/servercollectors/(?P<serverCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armmigrate.ServerCollector](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	serverCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverCollectorName")])
	if err != nil {
		return nil, err
	}
	var options *armmigrate.ServerCollectorsClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armmigrate.ServerCollectorsClientCreateOptions{
			CollectorBody: &body,
		}
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, projectNameParam, serverCollectorNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerCollector, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (s *ServerCollectorsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/servercollectors/(?P<serverCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	serverCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverCollectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, projectNameParam, serverCollectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (s *ServerCollectorsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/servercollectors/(?P<serverCollectorName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
	if err != nil {
		return nil, err
	}
	serverCollectorNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverCollectorName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, projectNameParam, serverCollectorNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerCollector, req)
	if err != nil {
		return nil, err
	}
	if val := server.GetResponse(respr).XMSRequestID; val != nil {
		resp.Header.Set("x-ms-request-id", *val)
	}
	return resp, nil
}

func (s *ServerCollectorsServerTransport) dispatchNewListByProjectPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListByProjectPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByProjectPager not implemented")}
	}
	newListByProjectPager := s.newListByProjectPager.get(req)
	if newListByProjectPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Migrate/assessmentProjects/(?P<projectName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/servercollectors`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		projectNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("projectName")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListByProjectPager(resourceGroupNameParam, projectNameParam, nil)
		newListByProjectPager = &resp
		s.newListByProjectPager.add(req, newListByProjectPager)
	}
	resp, err := server.PagerResponderNext(newListByProjectPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListByProjectPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByProjectPager) {
		s.newListByProjectPager.remove(req)
	}
	return resp, nil
}
